/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.moduleviews;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.colony.buildings.modules.IEntityListModuleView;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.modules.EntityListModuleWindow;
import com.minecolonies.coremod.network.messages.server.colony.building.AssignFilterableEntityMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class EntityListModuleView
extends AbstractBuildingModuleView
implements IEntityListModuleView {
    private final List<ResourceLocation> listOfEntities = new ArrayList<ResourceLocation>();
    private final String id;
    private final boolean inverted;
    private final String desc;

    public EntityListModuleView(String id, String desc, boolean inverted) {
        this.id = id;
        this.desc = desc;
        this.inverted = inverted;
    }

    @Override
    public void addEntity(ResourceLocation entity) {
        Network.getNetwork().sendToServer(new AssignFilterableEntityMessage(this.buildingView, this.id, entity, true));
        this.listOfEntities.add(entity);
    }

    @Override
    public boolean isAllowedEntity(ResourceLocation entity) {
        return this.listOfEntities.contains(entity);
    }

    @Override
    public int getSize() {
        return this.listOfEntities.size();
    }

    @Override
    public void removeEntity(ResourceLocation entity) {
        Network.getNetwork().sendToServer(new AssignFilterableEntityMessage(this.buildingView, this.id, entity, false));
        this.listOfEntities.remove(entity);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isInverted() {
        return this.inverted;
    }

    @Override
    public void clearEntities() {
        this.listOfEntities.clear();
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public void deserialize(@NotNull PacketBuffer buf) {
        this.listOfEntities.clear();
        int size = buf.readInt();
        for (int j = 0; j < size; ++j) {
            this.listOfEntities.add(((EntityType)buf.readRegistryIdUnsafe(ForgeRegistries.ENTITIES)).getRegistryName());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Window getWindow() {
        return new EntityListModuleWindow("minecolonies:gui/layouthuts/layoutfilterableentitylist.xml", this.buildingView, this);
    }

    @Override
    public String getIcon() {
        return "workers";
    }
}

